"""
HB_ToggleMode V1.2

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_ToggleMode
Description-US: Toggles Components Mode and does some other niffty things. (Details in Script)

This Script does following things:
1. Toggle Components Mode (Points/Edges/Polygons)
2. Selects all non parametric Objects that are child of selected Objects (eg. If you have selected a SubdivisionSurface the Script will
select all Polygonobjects that are children)
2. Enables Displayfilter Splines (Only If splines are selected)
3. Enables Xray Display if Splines are Selected and keeps Generarors like Sweep selected so you can see through them.
4. Selects and Frames Instance-Referenz if Instance is selected and creates a temporal ModellingCamera
5. If no object is selected the object under the cursor will be selected

Video Tutorial:
https://youtu.be/eEcAttV56kE?t=10m46s

https://youtu.be/rAHc5mstOCg?t=1234

ChangeLog:

Jun/11/2015 V1.0
- Release Version

Oct/5/2015 V1.1
-CorrectionDeformer works now


Oct/11/2018 V1.2
- New Highres Icon
- Added: Selects Object under cursor if no object is selected
- Support for Extrude Object X-Ray mode

"""
import c4d
from c4d import documents, storage, gui

def GetNextObject(op,root):

    if op.GetType()==c4d.Opolygon or op.GetType()==c4d.Ospline or op.GetType()==c4d.Osweep or op.GetType()==c4d.Olathe or op.GetType()==1026224 or op.GetType()==1024542 or op.GetType()==c4d.Oextrude:
        op.SetBit(c4d.BIT_ACTIVE)
    if op.GetType()==c4d.Ospline or op.GetType()==c4d.Osweep or op.GetType()==c4d.Olathe or op.GetType()==c4d.Oextrude:
        drawBD = doc.GetActiveBaseDraw()
        drawBD[c4d.BASEDRAW_DATA_XRAY]=True
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_SPLINE]=True

    if op==None:
        return None

    if op.GetDown():
        return op.GetDown()

    while not op.GetNext() and op!=root and op.GetUp()!=root and op.GetUp():
        op = op.GetUp()

    if op !=root:
        return op.GetNext()


def IterateChildren(objlist):

    for obj in objlist:

        if obj.GetType()!=c4d.Opolygon or obj.GetType()!=c4d.Ospline or obj.GetType()!=c4d.Osweep or obj.GetType()!=c4d.Olathe or obj.GetType()!=c4d.Osymmetry or op.GetType()==1024542:
            obj.DelBit(c4d.BIT_ACTIVE)

        root = obj
        while obj:
            obj = GetNextObject(obj,root)


    if obj is None:
        return

    return



### Select object under Cursor
def PickObj():


    bd = doc.GetActiveBaseDraw()
    bc = c4d.BaseContainer()

    gui.GetInputState(c4d.BFM_INPUT_MOUSE, c4d.BFM_INPUT_MOUSELEFT, bc)
    mouse_x=bc.GetInt32(c4d.BFM_INPUT_X)
    mouse_y=bc.GetInt32(c4d.BFM_INPUT_Y)

    # Convert MouseCoordinates to Viewport Coordinates
    win= bd.GetEditorWindow()
    Editor_x, Editor_y = win.Global2Local()
    mouse_x = mouse_x-abs(Editor_x)
    mouse_y = mouse_y-abs(Editor_y)

    ViewportSelect = c4d.utils.ViewportSelect()
    pick_objects = ViewportSelect.PickObject(bd, doc, mouse_x, mouse_y, rad=0, flags=c4d.VIEWPORT_PICK_FLAGS_0)
    #print "PickObj: ", pick_objects[0].GetName()

    frame = bd.GetFrame()
    left = frame["cl"]
    right = frame["cr"]
    top = frame["ct"]
    bottom = frame["cb"]
    width = right - left + 1
    height = bottom - top +1


    for obj in pick_objects:
        obj_info = obj.GetInfo()
        is_deformer = obj_info & c4d.OBJECT_MODIFIER
        if not is_deformer:
            return obj



# If selection is INSTANCE

def InstanceCheck(SelObj):
    #if SelObj == none: return
    for obj in SelObj:
        if obj.GetType()==c4d.Oinstance:
            reflink=obj[c4d.INSTANCEOBJECT_LINK]
            reflink.SetBit(c4d.BIT_ACTIVE)
            obj.DelBit(c4d.BIT_ACTIVE)

            #Setup Modelling Camera
            CamPos = doc.GetActiveBaseDraw()[c4d.BASEDRAW_DATA_CAMERA].GetMg()
            if not doc.SearchObject("HB_ModellingCamera_ROOT"):

                Camera_ROOT=c4d.BaseObject(c4d.Onull)
                Camera_ROOT.SetName("HB_ModellingCamera_ROOT")

                doc.AddUndo(c4d.UNDOTYPE_NEW, Camera_ROOT)
                Camera_ROOT[c4d.ID_BASEOBJECT_VISIBILITY_EDITOR]=1
                doc.InsertObject(Camera_ROOT)

                WorkplaneCamera=c4d.BaseObject(c4d.Ocamera)
                WorkplaneCamera.SetName("ModellingCamera")
                doc.AddUndo(c4d.UNDOTYPE_NEW, WorkplaneCamera)
                WorkplaneCamera.InsertUnder(Camera_ROOT)
                WorkplaneCamera.SetMg(CamPos)


            doc.GetActiveBaseDraw()[c4d.BASEDRAW_DATA_CAMERA]=WorkplaneCamera



            c4d.CallCommand(13038) # Frame Selected Elements


def InstanceCheckNew(obj):
    if obj == None: return

    if obj[0].GetType()==c4d.Oinstance:
        reflink=obj[0][c4d.INSTANCEOBJECT_LINK]
        reflink.SetBit(c4d.BIT_ACTIVE)
        obj[0].DelBit(c4d.BIT_ACTIVE)

        #Setup Modelling Camera
        CamPos = doc.GetActiveBaseDraw()[c4d.BASEDRAW_DATA_CAMERA].GetMg()
        if not doc.SearchObject("HB_ModellingCamera_ROOT"):

            Camera_ROOT=c4d.BaseObject(c4d.Onull)
            Camera_ROOT.SetName("HB_ModellingCamera_ROOT")

            doc.AddUndo(c4d.UNDOTYPE_NEW, Camera_ROOT)
            Camera_ROOT[c4d.ID_BASEOBJECT_VISIBILITY_EDITOR]=1
            doc.InsertObject(Camera_ROOT)

            WorkplaneCamera=c4d.BaseObject(c4d.Ocamera)
            WorkplaneCamera.SetName("ModellingCamera")
            doc.AddUndo(c4d.UNDOTYPE_NEW, WorkplaneCamera)
            WorkplaneCamera.InsertUnder(Camera_ROOT)
            WorkplaneCamera.SetMg(CamPos)


        doc.GetActiveBaseDraw()[c4d.BASEDRAW_DATA_CAMERA]=WorkplaneCamera
        c4d.CallCommand(13038) # Frame Selected Elements

def main():


    if doc.GetSelection():

        selobjs=doc.GetSelection()

    else:

        selobjs=PickObj()


        if selobjs== None:

            c4d.CallCommand(13322)
            return # Toggle Modeling Mode

        selobjs=[PickObj()]



    if InstanceCheckNew(selobjs):
        InstanceCheck(selobjs)
        c4d.CallCommand(13322) # Toggle Modeling Mode
        return


    IterateChildren(selobjs)
    c4d.CallCommand(13322) # Toggle Modeling Mode
    c4d.EventAdd()

if __name__=='__main__':
    main()